char *trans_pl=(char *)
/* file automatically generated by fileToC.sh from trans.pl */
"%\n"
"% By Marcello Balduccini [102208]\n"
"%\n"
"% Copyright (C) 2009-2021 Marcello Balduccini. All Rights Reserved.\n"
"%\n"
"\n"
"\n"
":- use_module(library(system)).\n"
":- use_module(library(lists)).\n"
":- use_module(library(charsio)).\n"
":- use_module(library(terms)).\n"
"\n"
"\n"
":- use_module(library(timeout)).\n"
"\n"
"\n"
":- use_module(library(codesio)).	% charsio was renamed in Sicstus4\n"
"\n"
"\n"
"\n"
"sicstus4 :- current_module(codesio).\n"
"%\n"
"my_write_to_chars(X,Y) :- sicstus4, write_to_codes(X,Y).\n"
"my_write_to_chars(X,Y) :- \\+ sicstus4, write_to_chars(X,Y).\n"
"%\n"
"my_nth(X,Y,Z) :- sicstus4, nth1(X,Y,Z).\n"
"my_nth(X,Y,Z) :- \\+ sicstus4, nth(X,Y,Z).\n"
"\n"
"translate_batch :-\n"
"	%nofileerrors,\n"
"	set_prolog_flag(fileerrors,off),\n"
"	nodebug,\n"
"	set_prolog_flag(unknown,fail),\n"
"	write('=-=-=-=-='),nl,\n"
"	translate,\n"
"        halt.\n"
"\n"
"translate_batch :-  % batch must always succeed.\n"
"        write('++failed'),nl,\n"
"        halt.\n"
"\n"
"\n"
"parse(CSPDomain,Vars,Mapping,Domains,Constraints,LabelOptions) :-\n"
"	parse_cspdomain(CSPDomain),\n"
"	parse_cspvar(CSPDomain,Mapping,UnorderedVars,Domains),\n"
"	parse_required(CSPDomain,Mapping,Constraints),\n"
"	parse_label_order(Mapping,UnorderedVars,LabelOrder,Vars),\n"
"	parse_label_options(LabelOptions).\n"
"\n"
"\n"
"\n"
"% [marcy 041510]\n"
"% translate currently supports only CSPDomain fd!!!\n"
"%\n"
"translate([CLPsolver,Clause]) :-\n"
"	parse(CSPDomain,Vars,Mapping,Domains,Constraints,LabelOptions),\n"
"	prepare_cspdomain(CSPDomain,CLPsolver),\n"
"	prepare_varlist(Vars,Body0),\n"
"	prepare_domains(Domains,Vars,Body1,DomainClauses),\n"
"	prepare_constraints(Constraints,Vars,Body2,ConstraintClauses),\n"
"	prepare_labeling(Vars,LabelOrder,LabelOptions,Body3),\n"
"	prepare_ifx_mapping(Mapping,Vars,Body4,MappingClauses,ResMapping),\n"
"	append(Body0,Body1,Body01),\n"
"	append(Body01,Body2,Body012),\n"
"	append(Body012,Body3,Body0123),\n"
"	append(Body0123,Body4,Body01234),\n"
"	turn_into_commas(Body01234,Body),\n"
"	Clause = ( solve(ResMapping) :- Body ),\n"
"	append(DomainClauses,ConstraintClauses,AllClauses1),\n"
"	append(AllClauses1,MappingClauses,AllClauses),\n"
"	portray_clauses([(:- CLPsolver),(:-use_module(library(lists))),Clause|AllClauses]).\n"
"\n"
"translate :-\n"
"	translate(_).\n"
"\n"
"\n"
"%\n"
"% Called by exec.pl's batch & co. predicates when we are\n"
"% running the translation and execution steps together.\n"
"% In that case, predicate translate/1 above is NOT called.\n"
"%\n"
"solve(FinalMapping) :-\n"
"	parse(CSPDomain,Vars,Mapping,Domains,Constraints,LabelOptions),\n"
"	prepare_cspdomain(CSPDomain,CLPsolver),\n"
"	CLPsolver,\n"
"	use_module(library(lists)),\n"
"	prepare_varlist(Vars,Body0),\n"
"	run_domains(CSPDomain,Domains,Vars,Body1,DomainClauses),\n"
"	run_constraints(CSPDomain,Constraints,Vars,Body2,ConstraintClauses),\n"
"	run_labeling(CSPDomain,Vars,LabelOrder,LabelOptions,Body3,Mapping,FinalMapping).\n"
"\n"
"\n"
"parse_cspdomain(D) :-\n"
"	cspdomain(D),\n"
"	!.\n"
"%\n"
"parse_cspdomain(fd).	% now we use the FD domain by default\n"
"%parse_cspdomain(_) :-\n"
"%	write('No CSP domain specified with ASP relation cspdomain(_). Unable to proceed.'),nl,\n"
"%	fail.\n"
"\n"
"\n"
"\n"
"parse_cspvar(CSPDomain,Mapping,Vars,Domains) :-\n"
"	findall_or_empty((ASPName,MinRange,MaxRange),cspvar(ASPName,MinRange,MaxRange),Decl),\n"
"	%\n"
"	length(Decl,N),\n"
"	length(Vars,N),\n"
"	%\n"
"	(CSPDomain = fd -> \n"
"		fdbg_assign_name(Vars,myvars)	%%% [marcy 021810]\n"
"	 ;\n"
"	 	true\n"
"	),\n"
"	%\n"
"	form_mapping(Decl,Vars,UnsortedMapping),\n"
"	% sort to ensure that the result of form_var_list() \n"
"	% always corresponds to a sorted list of ASPNames.\n"
"  	sort(UnsortedMapping,Mapping),\n"
"	form_domains(Decl,Vars,Domains).\n"
"%\n"
"form_mapping([],_,[]).\n"
"%\n"
"form_mapping([(ASPName,_,_)|DeclTail],[Var|VarTail],[(ASPName,Var)|MapTail]) :-\n"
"	form_mapping(DeclTail,VarTail,MapTail).\n"
"%\n"
"form_domains([],_,[]).\n"
"%\n"
"form_domains([(_,MinRange,MaxRange)|DeclTail],[Var|VarTail],[(Var,MinRange,MaxRange)|DomTail]) :-\n"
"	form_domains(DeclTail,VarTail,DomTail).\n"
"\n"
"\n"
"get_vars_objvar(VarsV) :-\n"
"	numbervars(VarsV,10000,_).\n"
"\n"
"\n"
"get_var(ASPName,Mapping,Var) :-\n"
"	my_nth(_,Mapping,(ASPName,Var)).\n"
"\n"
"\n"
"get_var_and_element(ASPName,Mapping,Var,(ASPName,Var)) :-\n"
"	my_nth(_,Mapping,(ASPName,Var)).\n"
"\n"
"get_index(Var,Vars,N) :-\n"
"%	my_nth(N,Vars,Var).\n"
"%	write_to_chars(Var,[_|IndexChars]), number_chars(N,IndexChars).\n"
"	var_nth(N,Vars,Var).\n"
"\n"
"%\n"
"% A variant of nth/3 that correctly matches\n"
"% variables by their NAME. For example:\n"
"%\n"
"%    var_nth(N,[X,Y],Y) succeeds for N=2\n"
"%\n"
"% while\n"
"%\n"
"%    my_nth(N,[X,Y],Y) succeeds for N=1,2.\n"
"%\n"
"var_nth(N,Vars,Var) :-\n"
"	var_nth(Var,Vars,1,N).\n"
"\n"
"var_nth(Var,[Elem|_],N,N) :-\n"
"	var_is_same(Var,Elem),\n"
"	my_write_to_chars(Var,AnonymChars),\n"
"	my_write_to_chars(Elem,AnonymChars),\n"
"	!.\n"
"\n"
"var_nth(Var,[_|Tail],I,N) :-\n"
"	I2 is I + 1,\n"
"	var_nth(Var,Tail,I2,N).\n"
"\n"
"%\n"
"% Check if two specified variables have the same NAME.\n"
"%\n"
"var_is_same(VA,VB) :-\n"
"	my_write_to_chars(VA,AnonymChars),\n"
"	my_write_to_chars(VB,AnonymChars).\n"
"\n"
"\n"
"is_csp_variable((FuncSym,Arity),Mapping) :-\n"
"	FuncSym =.. [ASPFunc|GivenArgs],\n"
"	length(GivenArgs,NgivenArgs),\n"
"	NmissingArgs is Arity - NgivenArgs,\n"
"	length(MissingArgs,NmissingArgs),\n"
"	append(GivenArgs,MissingArgs,ARGS),\n"
"	ASPName =.. [ASPFunc|ARGS],\n"
"	get_var(ASPName,Mapping,_).\n"
"\n"
"\n"
"\n"
"parse_required(CSPDomain,Mapping,Constraints) :-\n"
"	findall_or_empty(CONSTR,required(CONSTR),CONSTRlist),\n"
"	parse_constraints(CSPDomain,CONSTRlist,Mapping,Constraints).\n"
"\n"
"\n"
"parse_constraints(CSPDomain,[CONSTR|CONSTRlist],Mapping,[TransConstraint|Constraints]) :-\n"
"%	write('translating constraint: '),write(CONSTR),nl,\n"
"	CONSTR =.. [REL|ARGS],\n"
"%	write('rel args: '),write(REL),write('|'),write(ARGS),nl,\n"
"	parse_constraint(CSPDomain,REL,ARGS,Mapping,TransConstraint),\n"
"%	write('  translated constraint: '),write(TransConstraint),nl,\n"
"	parse_constraints(CSPDomain,CONSTRlist,Mapping,Constraints).\n"
"\n"
"parse_constraints(_,[],_,[]).\n"
"\n"
"\n"
"% unary constraints\n"
"parse_constraint(CSPDomain,REL,[EXPR],Mapping,Constraint) :-\n"
"	is_local_constraint(REL),\n"
"	!,	% prevent from backtracking into 'catch-all' rule below\n"
"	map_local_constraint(CSPDomain,REL,CSPrel),\n"
"	map_expr(EXPR,Mapping,CSPexpr),\n"
"	Constraint =.. [CSPrel,CSPexpr].\n"
"\n"
"% binary constraints\n"
"parse_constraint(CSPDomain,REL,[EXPR1,EXPR2],Mapping,Constraint) :-\n"
"	is_local_constraint(REL),\n"
"	!,	% prevent from backtracking into 'catch-all' rule below\n"
"	map_local_constraint(CSPDomain,REL,CSPrel),\n"
"	map_expr(EXPR1,Mapping,CSPexpr1),\n"
"	map_expr(EXPR2,Mapping,CSPexpr2),\n"
"	Constraint =.. [CSPrel,CSPexpr1,CSPexpr2].\n"
"\n"
"parse_constraint(_,REL,ARGS,Mapping,Constraint) :-\n"
"	is_global_constraint(REL,ARGS),\n"
"	!,	% prevent from backtracking into 'catch-all' rule below\n"
"	map_global_constraint(REL,ARGS,PLREL),\n"
"	process_global_args(REL,ARGS,Mapping,CONSTRargs),\n"
"	Constraint =.. [PLREL|CONSTRargs].\n"
"\n"
"\n"
"parse_constraint(_,OTHER_CONSTR,ARGS,_,_) :-\n"
"	Atom =.. [OTHER_CONSTR|ARGS],\n"
"	write('***unhandled constraint: '),write(Atom),nl,\n"
"	fail.\n"
"\n"
"\n"
"is_global_constraint(REL,ARGS) :-\n"
"	length(ARGS,Nargs),\n"
"	global_constraint_spec(REL,Nargs,_).\n"
"\n"
"\n"
"process_global_args(REL,ARGS,Mapping,CONSTRargs) :-\n"
"	length(ARGS,Arity),\n"
"	global_constraint_spec(REL,Arity,ARGspecs),\n"
"	process_global_args(REL,ARGspecs,ARGS,Mapping,CONSTRargs).\n"
"%\n"
"process_global_args(REL,[ARGspec|ARGspecs],[ARG|ARGS],Mapping,[CONSTRarg|CONSTRargs]) :-\n"
"	process_global_arg(ARGspec,ARG,Mapping,CONSTRarg),\n"
"	process_global_args(REL,ARGspecs,ARGS,Mapping,CONSTRargs).\n"
"%\n"
"process_global_args(_,[],_,_,[]).\n"
"\n"
"\n"
"\n"
"%\n"
"% NOTICE: FuncSym can be a compound term. In this case,\n"
"%         that means the first, given arguments are fixed.\n"
"%         E.g. list(f(a),2) means all terms of the form\n"
"%                        f(a,t)\n"
"%         where t is a term.\n"
"%\n"
"process_global_arg(_,list(FuncSym,Arity),Mapping,CONSTRarg) :-\n"
"	is_csp_variable((FuncSym,Arity),Mapping),\n"
"	!,  % to avoid the next case: list(RelSym,Arity)\n"
"	form_var_list((FuncSym,Arity),Mapping,CONSTRarg).\n"
"\n"
"%\n"
"% NOTICE: RelSym can be a compound term. In this case,\n"
"%         that means the first, given arguments are fixed.\n"
"%         E.g. list(f(a),2) means all terms of the form\n"
"%                        f(a,t)\n"
"%         where t is a term.\n"
"%\n"
"process_global_arg(_,list(RelSym,Arity),_,CONSTRarg) :-\n"
"	form_rel_value_list((RelSym,Arity),CONSTRarg),\n"
"	!.  % to avoid the final 'catch-all' case.\n"
"\n"
"% process extensively-represented lists\n"
"process_global_arg(_,ExtList,Mapping,CONSTRarg) :-\n"
"	ExtList =.. [extlist|List],\n"
"	form_gen_list(List,Mapping,CONSTRarg),\n"
"	!.  % to avoid the final 'catch-all' case.\n"
"\n"
"process_global_arg(_,REL,_,CSPrel) :-\n"
"	map_local_constraint(fd,REL,CSPrel),	% specify fd because we are in the context of finite domains\n"
"	!.  % to avoid the next 'catch-all' case.\n"
"\n"
"process_global_arg(_,ARG,Mapping,CONSTRarg) :-\n"
"	map_expr(ARG,Mapping,CONSTRarg).\n"
"\n"
"\n"
"% The result (3rd arg) is always sorted w.r.t. to the\n"
"% corresponding ASPNames because of the sort() in parse_cspvar().\n"
"%\n"
"form_var_list(_,[],[]).\n"
"%\n"
"form_var_list((FuncSym,Arity),[(ASPName,Var)|MapTail],[Var|VTail]) :-\n"
"	FuncSym =.. [ASPFunc|GivenArgs],\n"
"	length(GivenArgs,NgivenArgs),\n"
"	NmissingArgs is Arity - NgivenArgs,\n"
"	length(MissingArgs,NmissingArgs),\n"
"	append(GivenArgs,MissingArgs,ARGS),\n"
"	ASPName =.. [ASPFunc|ARGS],\n"
"	!, % avoid the next 'default' case\n"
"	form_var_list((FuncSym,Arity),MapTail,VTail).\n"
"%\n"
"form_var_list((FuncSym,Arity),[_|MapTail],VTail) :-\n"
"	form_var_list((FuncSym,Arity),MapTail,VTail).\n"
"\n"
"\n"
"form_gen_list([],_,[]).\n"
"%\n"
"form_gen_list([Item|ITail],Mapping,[Var|VTail]) :-\n"
"	Item =.. [FuncSym|Args],\n"
"	length(Args,Arity),\n"
"	is_csp_variable((Item,Arity),Mapping),\n"
"	!, % avoid the next 'default' case\n"
"	form_var_list((Item,Arity),Mapping,[Var]),\n"
"	form_gen_list(ITail,Mapping,VTail).\n"
"%\n"
"form_gen_list([Item|ITail],Mapping,[Item|VTail]) :-\n"
"	Item =.. [FuncSym], % no args -- constant\n"
"	!, % avoid the next 'default' case\n"
"	form_gen_list(ITail,Mapping,VTail).\n"
"%\n"
"form_gen_list([Item|ITail],Mapping,[Val|VTail]) :-\n"
"	Item =.. [FuncSym|Args],\n"
"	length(Args,Arity),\n"
"	form_rel_value_list((Item,Arity),[Val]),\n"
"	form_gen_list(ITail,Mapping,VTail).\n"
"\n"
"\n"
"form_rel_value_list((RelSym,Arity),ValList) :-\n"
"	RelSym =.. [ASPFunc|GivenArgs],\n"
"	length(GivenArgs,NgivenArgs),\n"
"	NmissingArgs is Arity - NgivenArgs,\n"
"	length(MissingArgs,NmissingArgs),\n"
"	append(GivenArgs,MissingArgs,ARGS),\n"
"	GenTerm =.. [ASPFunc|ARGS],\n"
"	findall_or_empty(GenTerm,GenTerm,UnsortedTermList),\n"
"	sort(UnsortedTermList,TermList),\n"
"	extract_list_of_last_args(TermList,ValList).\n"
"\n"
"extract_list_of_last_args([Term|Terms],[Val|ValList]) :-\n"
"	Term =.. [_|Args],\n"
"	last(Args,Val),\n"
"	extract_list_of_last_args(Terms,ValList).\n"
"\n"
"extract_list_of_last_args([],[]).\n"
"\n"
"\n"
"% My version of findall, which does not fail\n"
"% if the Template is not found.\n"
"%\n"
"findall_or_empty(Item,Template,List) :-\n"
"	current_prolog_flag(unknown,Old),\n"
"	set_prolog_flag(unknown,fail),\n"
"	findall(Item,Template,List),\n"
"	set_prolog_flag(unknown,Old).\n"
"\n"
"\n"
"\n"
"map_expr(ASPName,Mapping,Var) :-\n"
"	get_var(ASPName,Mapping,Var),\n"
"	% Then it's just a CSP variable.\n"
"	% Avoid the 'default' case below.\n"
"	!.\n"
"\n"
"map_expr(Const,_,Const) :-\n"
"%	\\+ compound(Const),	% just \\+ compound won't catch non-numerical constants as errors, although they normally are.\n"
"	number(Const),\n"
"	!.\n"
"\n"
"map_expr(EXPR,Mapping,CSPexpr) :-\n"
"	compound(EXPR),\n"
"	EXPR =.. [Func|Args],\n"
"	%write('got expr: '),write(EXPR),nl,\n"
"	% the following disjunction is because of\n"
"	% reified constraints.\n"
"	( map_csp_function(Func,CSPfunc) ; map_local_constraint(fd,Func,CSPfunc) ), % specify fd because reified constraints allowed only in finite domains\n"
"	!,\n"
"	map_exprs(Args,Mapping,CSPargs),\n"
"	CSPexpr =.. [CSPfunc|CSPargs].\n"
"	%write('CSP expr is: '),write(CSPexpr),nl.\n"
"\n"
"map_expr(EXPR,_,_) :-\n"
"	write('***unhandled expression '),write(EXPR),nl,\n"
"	fail.\n"
"\n"
"\n"
"\n"
"map_exprs([Expr|ETail],Mapping,[CSPexpr|CSPTail]) :-\n"
"	map_expr(Expr,Mapping,CSPexpr),\n"
"	map_exprs(ETail,Mapping,CSPTail).\n"
"map_exprs([],_,[]).\n"
"\n"
"\n"
"map_asp_to_csp_order_list_and_unused([],_,Unused,[],Unused).\n"
"\n"
"map_asp_to_csp_order_list_and_unused([(Num,ASPName)|ASPTail],Mapping,UnusedSoFar,[Num-Var|CSPTail],Unused) :-\n"
"	get_var_and_element(ASPName,Mapping,Var,Element),\n"
"	delete(UnusedSoFar,Element,Residue),\n"
"	map_asp_to_csp_order_list_and_unused(ASPTail,Mapping,Residue,CSPTail,Unused).\n"
"\n"
"\n"
"parse_label_order(Mapping,Vars,CSPOrderList,OrderedVars) :-\n"
"	findall_or_empty((Num,ASPName),label_order(ASPName,Num),ASPOrderListManual),\n"
"	dors_check_stack_dump(ASPOrderListManual,ASPOrderList), %%% [marcy 021810]\n"
"	map_asp_to_csp_order_list_and_unused(ASPOrderList,Mapping,Mapping,CSPOrderList,UnusedMapping),\n"
"%	map_asp_to_csp_order_list(ASPOrderList,Mapping,CSPOrderList),\n"
"	keysort(CSPOrderList,SortedOrder),\n"
"	extract_variables(SortedOrder,SpecifiedVars),\n"
"	extract_variables_from_mapping(UnusedMapping,UnspecifiedVars),\n"
"%	list_diff(Vars,SpecifiedVars,UnspecifiedVars),\n"
"	append(SpecifiedVars,UnspecifiedVars,OrderedVars).\n"
"\n"
"extract_variables([],[]).\n"
"\n"
"extract_variables([(_-Var)|PairTail],[Var|VarTail]) :-\n"
"	extract_variables(PairTail,VarTail).\n"
"\n"
"extract_variables_from_mapping([],[]).\n"
"\n"
"extract_variables_from_mapping([(_,Var)|Tail],[Var|VarTail]) :-\n"
"	extract_variables_from_mapping(Tail,VarTail).\n"
"\n"
"%list_diff(List,[],List).\n"
"%\n"
"%list_diff(List,[Elem|RemoveTail],RemovedList) :-\n"
"%	var_delete(List,Elem,List2),\n"
"%	list_diff(List2,RemoveTail,RemovedList).\n"
"\n"
"%\n"
"% variant of delete/3 that works properly with\n"
"% lists of anonymous variables.\n"
"%\n"
"% NOTE: var_delete/3 deletes a SINGLE occurrence.\n"
"%\n"
"var_delete([],_,[]).\n"
"\n"
"var_delete([A|Tail],B,Tail) :-\n"
"	var_is_same(A,B),\n"
"	!.\n"
"\n"
"var_delete([A|Tail],B,[A|Res]) :-\n"
"	var_delete(Tail,B,Res).\n"
"\n"
"\n"
"\n"
"parse_label_options(LabelOptions) :-\n"
"	findall_or_empty(Opt,( label_option(RawOpt), map_csp_function(RawOpt,Opt) ),LabelOptions).\n"
"\n"
"\n"
"\n"
"prepare_cspdomain(fd,(use_module(library(clpfd)))).\n"
"%\n"
"prepare_cspdomain(q,(use_module(library(clpq)))).\n"
"%\n"
"prepare_cspdomain(r,(use_module(library(clpr)))).\n"
"\n"
"\n"
"prepare_varlist(Vars,[( length(VarsV,N) )] ) :-\n"
"	length(Vars,N),\n"
"	get_vars_objvar(VarsV).\n"
"\n"
"\n"
"prepare_domains([],_,[],\n"
"		[(dom(VN,VarsV,MinRange,MaxRange) :- nth1(VN,VarsV,V), domain([V],MinRange,MaxRange)) ]) :- sicstus4.\n"
"%\n"
"prepare_domains([],_,[],\n"
"		[(dom(VN,VarsV,MinRange,MaxRange) :- nth(VN,VarsV,V), domain([V],MinRange,MaxRange)) ]) :- \\+ sicstus4.\n"
"%\n"
"prepare_domains([(Var,MinRange,MaxRange)|DomTail],Vars,\n"
"		[dom(VN,VarsV,MinRange,MaxRange)|Body],\n"
"		DomainClauses):-\n"
"	length(DomTail,N),\n"
"	get_index(Var,Vars,VN),\n"
"	get_vars_objvar(VarsV),\n"
"	prepare_domains(DomTail,Vars,Body,DomainClauses).\n"
"\n"
"\n"
"run_domains(_,[],_,[],[]).\n"
"%\n"
"run_domains(fd,[(Var,MinRange,MaxRange)|DomTail],_,\n"
"		[],\n"
"		DomainClauses):-\n"
"	domain([Var],MinRange,MaxRange),\n"
"	run_domains(fd,DomTail,Vars,Body,DomainClauses).\n"
"%\n"
"run_domains(CSPDomain,[(Var,MinRange,MaxRange)|DomTail],_,\n"
"		[],\n"
"		DomainClauses):-\n"
"	( CSPDomain = r ; CSPDomain = q ),\n"
"	{ Var >= MinRange, Var =< MaxRange },\n"
"	run_domains(CSPDomain,DomTail,Vars,Body,DomainClauses).\n"
"\n"
"\n"
"prepare_constraints([],_,[],[]).\n"
"%\n"
"prepare_constraints([Constraint|Constraints],Vars,[constr(N,VarsV)|Calls],[(constr(N,VV) :- Body)|ConstraintClauses]) :-\n"
"	length(Constraints,N),\n"
"	get_vars_objvar(VarsV),\n"
"	term_variables(Constraint,ConstraintVars),\n"
"	form_nths(ConstraintVars,Vars,VV,NTHS),\n"
"	append(NTHS,[Constraint],BodyList),\n"
"	turn_into_commas(BodyList,Body),\n"
"	prepare_constraints(Constraints,Vars,Calls,ConstraintClauses).\n"
"\n"
"form_nths([],_,_,[]).\n"
"%\n"
"form_nths([Var|VarTail],Vars,VV,[nth1(Index,VV,Var)|NTHTail]) :-\n"
"	sicstus4,\n"
"	get_index(Var,Vars,Index),\n"
"	form_nths(VarTail,Vars,VV,NTHTail).\n"
"%\n"
"form_nths([Var|VarTail],Vars,VV,[nth(Index,VV,Var)|NTHTail]) :-\n"
"	\\+ sicstus4,\n"
"	get_index(Var,Vars,Index),\n"
"	form_nths(VarTail,Vars,VV,NTHTail).\n"
"\n"
"\n"
"run_constraints(_,[],_,[],[]).\n"
"%\n"
"run_constraints(fd,[Constraint|Constraints],Vars,Calls,ConstraintClauses) :-\n"
"	Constraint,\n"
"	run_constraints(fd,Constraints,Vars,Calls,ConstraintClauses).\n"
"%\n"
"run_constraints(CSPDomain,[Constraint|Constraints],Vars,Calls,ConstraintClauses) :-\n"
"	( CSPDomain = r ; CSPDomain = q ),\n"
"	{ Constraint },\n"
"	run_constraints(CSPDomain,Constraints,Vars,Calls,ConstraintClauses).\n"
"\n"
"\n"
"%\n"
"% WARNING [marcy 022510]\n"
"% Currently, prepare_labeling does not support using saved stacks.\n"
"%\n"
"prepare_labeling(Vars,_,LabelOptions,[labeling(LabelOptions,VarsV)]) :-\n"
"	get_vars_objvar(VarsV).\n"
"\n"
"\n"
"delete_var_sel([Option|LabelOptionsIN],LabelOptionsOUT) :-\n"
"	( Option = leftmost ;\n"
"	  Option = ff ;\n"
"	  Option = ffc ;\n"
"	  Option = min ;\n"
"	  Option = max ;\n"
"	  Option = variable(_)\n"
"	),\n"
"	!,\n"
"	delete_var_sel(LabelOptionsIN,LabelOptionsOUT).\n"
"\n"
"delete_var_sel([Option|LabelOptionsIN],[Option|LabelOptionsOUT]) :-\n"
"	delete_var_sel(LabelOptionsIN,LabelOptionsOUT).\n"
"\n"
"delete_var_sel([],[]).\n"
"\n"
"to_csp_rel(<,#<).\n"
"to_csp_rel(>,#>).\n"
"to_csp_rel(=<,#=<).\n"
"to_csp_rel(>=,#>=).\n"
"\n"
"invert_rel(<,>=).\n"
"invert_rel(>,=<).\n"
"invert_rel(>=,<).\n"
"invert_rel(=<,>).\n"
"\n"
"my_enum(_,X,Rest,BB0,BB) :-\n"
"	dors_stack(loaded),\n"
"	dors_stack_type(single),\n"
"	fdbg_annotate(X, fdvar(NameX,_,_) , _),\n"
"	get_fdvar_name(NameX,Name),\n"
"	\\+ dors_stack_in([bisect(Name,Rel,Val)|_]),\n"
"	write('***PROBLEM: my_enum decision at top of stack not about variable '), write(Name),nl,\n"
"	fail.\n"
"\n"
"my_enum(_,X,Rest,BB0,BB) :-\n"
"	dors_stack(loaded),\n"
"	dors_stack_type(single),\n"
"	fdbg_annotate(X, fdvar(NameX,_,_) , _),\n"
"	get_fdvar_name(NameX,Name),\n"
"	retract(dors_stack_in([bisect(Name,Rel,Val)|Stack])),\n"
"	!,\n"
"	(\n"
"		assert(dors_stack_in(Stack)),\n"
"		clpfd:fdbg_labeling_step(X,forced(Name,Rel,Val)),\n"
"		first_bound(BB0,BB),\n"
"		to_csp_rel(Rel,CSPRel),\n"
"		CSPConstraint =.. [CSPRel,X,Val],\n"
"		CSPConstraint\n"
"	;\n"
"		invert_rel(Rel,InvRel),\n"
"		clpfd:fdbg_labeling_step(X,backtrack_from_forced(Name,InvRel,Val)),\n"
"		later_bound(BB0,BB),\n"
"		to_csp_rel(InvRel,CSPRel),\n"
"		CSPConstraint =.. [CSPRel,X,Val],\n"
"		CSPConstraint\n"
"	).\n"
"\n"
"my_enum(_,X,Rest,BB0,BB) :-\n"
"	dors_stack(loaded),\n"
"	dors_stack_type(merged),\n"
"	fdbg_annotate(X, fdvar(NameX,_,_) , _),\n"
"	get_fdvar_name(NameX,Name),\n"
"	get_merged_choice_for_var(X,Name,Rel,Val),\n"
"	!,\n"
"	(\n"
"		clpfd:fdbg_labeling_step(X,forced(Name,Rel,Val)),\n"
"		first_bound(BB0,BB),\n"
"		to_csp_rel(Rel,CSPRel),\n"
"		CSPConstraint =.. [CSPRel,X,Val],\n"
"		CSPConstraint\n"
"	;\n"
"		invert_rel(Rel,InvRel),\n"
"		clpfd:fdbg_labeling_step(X,backtrack_from_forced(Name,InvRel,Val)),\n"
"		later_bound(BB0,BB),\n"
"		to_csp_rel(InvRel,CSPRel),\n"
"		CSPConstraint =.. [CSPRel,X,Val],\n"
"		CSPConstraint\n"
"	).\n"
"\n"
"get_merged_choice_for_var(V,Name,Rel,Val) :-\n"
"	dors_stack_in(Stack),\n"
"	current_decision_level(DLevel),\n"
"	\n"
"	level_choices(Stack,DLevel,Choices),\n"
"\n"
"	best_choice_for_var(V,Name,Choices,Rel,Val).\n"
"\n"
"my_enum(up,X,Rest,BB0,BB) :-\n"
"%	fdbg_annotate(X, fdvar(NameX,_,_) , _),\n"
"%	get_fdvar_name(NameX,Name),\n"
"%	write(Name),write(' in my enum1'),nl,\n"
"	fd_min(X,Min),\n"
"	fd_max(X,Max),\n"
"	Midpoint is (Min + Max) // 2,\n"
"	clpfd:fdbg_labeling_step(X,'$labeling_step'(var,=<,Midpoint,bisect)),\n"
"	first_bound(BB0,BB),\n"
"	%X in Min .. Midpoint.\n"
"	#=<(X,Midpoint).\n"
"%\n"
"% IMPORTANT: as far as I understand, \n"
"%            clpfd:fdbg_start_labeling(X) is called by labeling/2,\n"
"%            and should be called by custom replacements of labeling/2.\n"
"%            We don't need to call it from my_emu/5.\n"
"%\n"
"%	clpfd:fdbg_start_labeling(X).\n"
"\n"
"my_enum(up,X,Rest,BB0,BB) :-\n"
"%	fdbg_annotate(X, fdvar(NameX,_,_) , _),\n"
"%	get_fdvar_name(NameX,Name),\n"
"%	write(Name),write(' in my enum2'),nl,\n"
"	fd_min(X,Min),\n"
"	fd_max(X,Max),\n"
"	Midpoint is (Min + Max) // 2,\n"
"	clpfd:fdbg_labeling_step(X,'$labeling_step'(var,>,Midpoint,bisect)),\n"
"	later_bound(BB0,BB),\n"
"	#>(X,Midpoint).\n"
"	%X in Midpoint .. Max.\n"
"\n"
"my_enum(down,X,Rest,BB0,BB) :-\n"
"%	fdbg_annotate(X, fdvar(NameX,_,_) , _),\n"
"%	get_fdvar_name(NameX,Name),\n"
"%	write(Name),write(' in my enum1'),nl,\n"
"	fd_min(X,Min),\n"
"	fd_max(X,Max),\n"
"	Midpoint is (Min + Max) // 2 + 1,\n"
"	clpfd:fdbg_labeling_step(X,'$labeling_step'(var,>=,Midpoint,bisect)),\n"
"	first_bound(BB0,BB),\n"
"	%X in Min .. Midpoint.\n"
"	#>=(X,Midpoint).\n"
"%\n"
"% IMPORTANT: as far as I understand, \n"
"%            clpfd:fdbg_start_labeling(X) is called by labeling/2,\n"
"%            and should be called by custom replacements of labeling/2.\n"
"%            We don't need to call it from my_emu/5.\n"
"%\n"
"%	clpfd:fdbg_start_labeling(X).\n"
"\n"
"my_enum(down,X,Rest,BB0,BB) :-\n"
"%	fdbg_annotate(X, fdvar(NameX,_,_) , _),\n"
"%	get_fdvar_name(NameX,Name),\n"
"%	write(Name),write(' in my enum2'),nl,\n"
"	fd_min(X,Min),\n"
"	fd_max(X,Max),\n"
"	Midpoint is (Min + Max) // 2 + 1,\n"
"	clpfd:fdbg_labeling_step(X,'$labeling_step'(var,<,Midpoint,bisect)),\n"
"	later_bound(BB0,BB),\n"
"	#<(X,Midpoint).\n"
"	%X in Midpoint .. Max.\n"
"\n"
"get_var_from_fdname(FDName,[V|_],V) :-\n"
"	fdbg_annotate(V, fdvar(FDName,_,_) , _),\n"
"	!.\n"
"\n"
"get_var_from_fdname(FDName,[_|Vars],V) :-\n"
"	get_var_from_fdname(FDName,Vars,V).\n"
"\n"
"get_var_from_fdname(FDName,[],_) :-\n"
"	write('***PROBLEM: cannot find variable for fdname '),write(FDName),nl,\n"
"	fail.\n"
"	\n"
"\n"
"my_sel(_,Vars, V, NewVars) :-\n"
"	dors_stack(loaded),\n"
"	dors_stack_type(single),\n"
"	dors_stack_in([bisect(Name,Rel,Val)|Tail]),\n"
"write('selecting '),writeq(Name),nl,\n"
"	get_fdvar_name(FDName,Name),\n"
"	get_var_from_fdname(FDName,Vars,V),\n"
"	( Tail = [] -> NewVars=[]; NewVars=Vars),\n"
"	!.	% my_sel is required to be deterministic\n"
"\n"
"my_sel(_,Vars, V, NewVars) :-\n"
"	dors_stack(loaded),\n"
"	dors_stack_type(single),\n"
"	dors_stack_in([bisect(Name,Rel,Val)|Tail]),\n"
"	% If the previous clause backtracked, then that means\n"
"	% that the variable at the top of the stack has already\n"
"	% been assigned a value.\n"
"write('latest my_sel variable has been assigned a value. Skipping it.'),nl,\n"
"	retract(dors_stack_in([bisect(Name,Rel,Val)|Stack])),\n"
"	assert(dors_stack_in(Stack)),\n"
"	!,\n"
"	my_sel(_,Vars, V, NewVars).\n"
"\n"
"my_sel(_,Vars, V, Rest) :-\n"
"	dors_stack(loaded),\n"
"	dors_stack_type(merged),\n"
"	get_merged_choice(Vars,Name,V,Rest),\n"
"	!,\n"
"write('selecting '),writeq(Name),nl.\n"
"\n"
"get_merged_choice(Vars,Name,V,Vars) :-\n"
"	dors_stack_in(Stack),\n"
"	current_decision_level(DLevel),\n"
"	write('Decision level='),write(DLevel),nl,\n"
"	\n"
"	level_choices(Stack,DLevel,Choices),\n"
"\n"
"	best_choice(Choices,Vars,V,Name).\n"
"\n"
"current_decision_level(Level) :-\n"
"	choice_stack(Stack),\n"
"	length(Stack,Level0),\n"
"	Level is Level0 + 1.\n"
"\n"
"level_choices([Choices|_],1,Choices).\n"
"\n"
"level_choices([_|Stack],N,Choices) :-\n"
"	N > 1,\n"
"	N2 is N - 1,\n"
"	level_choices(Stack,N2,Choices).\n"
"\n"
"already_satisfied(V,>,Val) :-   %%%---\n"
"	fd_min(V,Min),\n"
"	Val < Min.\n"
"\n"
"already_satisfied(V,>,Val) :-   %%%---\n"
"	fd_max(V,Max),\n"
"	Val >= Max.\n"
"\n"
"already_satisfied(V,>=,Val) :-\n"
"	fd_min(V,Min),\n"
"	Val =< Min.\n"
"\n"
"already_satisfied(V,>=,Val) :-\n"
"	fd_max(V,Max),\n"
"	Val > Max.\n"
"\n"
"already_satisfied(V,<,Val) :-\n"
"	fd_min(V,Min),\n"
"	Val =< Min.\n"
"\n"
"already_satisfied(V,<,Val) :-\n"
"	fd_max(V,Max),\n"
"	Val > Max.\n"
"\n"
"already_satisfied(V,=<,Val) :-\n"
"	fd_min(V,Min),\n"
"	Val < Min.\n"
"\n"
"already_satisfied(V,=<,Val) :-\n"
"	fd_max(V,Max),\n"
"	Val >= Max.\n"
"\n"
"% ASSUMPTION: choices in Choices are ordered\n"
"% in descending order of occurrence count.\n"
"best_choice_for_var(V,Name,[(bisect(Name,Rel,Val),_)|_],Rel,Val) :-\n"
"	%\n"
"	% Avoid choices that are already satisfied\n"
"	% (e.g. V>30 when V's range is already 50..80).\n"
"	% Not only those choices are useless, but they can also\n"
"	% fool our auto-detection of backtracking\n"
"	% (see predicate in_stack).\n"
"	%\n"
"	\\+ already_satisfied(V,Rel,Val),\n"
"	!.\n"
"%\n"
"best_choice_for_var(V,Name,[(bisect2(Name,Rel),_)|_],Rel,Val) :-\n"
"	fd_min(X,Min),\n"
"	fd_max(X,Max),\n"
"	Val is (Min + Max) // 2,\n"
"	!.\n"
"%\n"
"best_choice_for_var(V,Name,[_|Choices],Rel,Val) :-\n"
"	best_choice_for_var(V,Name,Choices,Rel,Val).\n"
"\n"
"% ASSUMPTION: choices in Choices are ordered\n"
"% in descending order of occurrence count.\n"
"best_choice([(bisect(Name,Rel,Val),_)|_],Vars,V,Name) :-\n"
"	get_fdvar_name(FDName,Name),\n"
"	get_var_from_fdname(FDName,Vars,V),\n"
"	\\+ integer(V),\n"
"	%\n"
"	% Avoid choices that are already satisfied\n"
"	% (e.g. V>30 when V's range is already 50..80).\n"
"	% Not only those choices are useless, but they can also\n"
"	% fool our auto-detection of backtracking\n"
"	% (see predicate in_stack).\n"
"	%\n"
"	\\+ already_satisfied(V,Rel,Val),\n"
"	fd_min(V,Min),\n"
"	fd_max(V,Max),\n"
"write('the choice is '),write((V,Rel,Val,range(Min,Max))),nl,\n"
"	!.\n"
"%\n"
"best_choice([(bisect2(Name,Rel),_)|_],Vars,V,Name) :-\n"
"	get_fdvar_name(FDName,Name),\n"
"	get_var_from_fdname(FDName,Vars,V),\n"
"	\\+ integer(V),\n"
"	!.\n"
"%\n"
"best_choice([_|Choices],Vars,V,Name) :-\n"
"	best_choice(Choices,Vars,V,Name).\n"
"\n"
"\n"
"my_sel(leftmost,[V|Vars], V, Vars) :-\n"
"	write('***PROBLEM: my_sel is resorting to leftmost'),nl.\n"
"\n"
"my_sel(ff,[V|Vars], X, Rest) :-\n"
"	write('***PROBLEM: my_sel is resorting to ff'),nl,\n"
"	fd_size(V,S),\n"
"	my_sel_ff(Vars,V,S,X,Rest).\n"
"\n"
"my_sel_ff([],X,_,X,[]).\n"
"\n"
"my_sel_ff([V|Vars],V0,S0,X,Rest) :-\n"
"	integer(V), !,\n"
"	my_sel_ff(Vars,V0,S0,X,Rest).\n"
"\n"
"my_sel_ff([V|Vars],V0,S0,X,[Y|Rest]) :-\n"
"	fd_size(V,S),\n"
"	(	S < S0 -> Y=V0, my_sel_ff(Vars,V,S,X,Rest)\n"
"	;	Y=V, my_sel_ff(Vars,V0,S0,X,Rest)\n"
"	).\n"
"\n"
"run_labeling(fd,Vars,_,LabelOptions,[],Mapping,Mapping) :-\n"
"	dors_store_fdvar_names(Mapping),	% [marcy 021810] asserts relation varmap\n"
"	( dors_stack(loaded) ->\n"
"		( write('using saved stack'),nl,\n"
"		  delete_var_sel(LabelOptions,LabelOptions2),\n"
"%		  labeling([leftmost|LabelOptions2],Vars) ) ; % [marcy 021810]\n"
"%---------------------\n"
"% IMPORTANT: when using value/1 option in labeling/2,\n"
"%            up and down must NOT be specified. Doing\n"
"%            so causes labeling/2 to fail without any\n"
"%            warning or error message.\n"
"% [marcy 030310]\n"
"%---------------------\n"
"		  labeling([variable(my_sel(ff)),value(my_enum(up)),all],Vars)\n"
"		)\n"
"		; % [marcy 021810]\n"
"		( write('using stack from program'),nl, labeling(LabelOptions,Vars)) % [marcy 021810]\n"
"	),\n"
"	dors_output_stack. % [marcy 021810]\n"
"%\n"
"run_labeling(CSPDomain,Vars,_,_,[],Mapping,FinalMapping) :-\n"
"	( CSPDomain = r ; CSPDomain = q ),\n"
"	form_final_mapping(Vars,Mapping,FinalMapping).\n"
"\n"
"form_final_mapping(Q,Mapping,FinalMapping) :-\n"
"	remove_value_assigned(Q,Q2),\n"
"	value_assigned_mapping(Mapping,VMapping),\n"
"	form_final_mapping2(Q2,Mapping,RQMapping),\n"
"	append(VMapping,RQMapping,FinalMapping).\n"
"\n"
"remove_value_assigned([],[]).\n"
"remove_value_assigned([V|Q],[V|Q2]) :-\n"
"	var(V),\n"
"	!,\n"
"	remove_value_assigned(Q,Q2).\n"
"remove_value_assigned([_|Q],Q2) :-\n"
"	remove_value_assigned(Q,Q2).\n"
"\n"
"value_assigned_mapping([],[]).\n"
"value_assigned_mapping([(ASPName,V)|Mapping],[(ASPName,V)|VMapping]) :-\n"
"	\\+ var(V),\n"
"	!,\n"
"	value_assigned_mapping(Mapping,VMapping).\n"
"value_assigned_mapping([_|Mapping],VMapping) :-\n"
"	value_assigned_mapping(Mapping,VMapping).\n"
"\n"
"\n"
"form_final_mapping2(Q, Mapping, A) :-\n"
"	dump(Q,V,C),\n"
"	rename_termlist(C,A,Q,V,Mapping).\n"
"\n"
"rename_termlist([Arg|Args],[RenArg|RenArgs],Q,V,Mapping) :-\n"
"	rename_term(Arg,RenArg,Q,V,Mapping),\n"
"	rename_termlist(Args,RenArgs,Q,V,Mapping).\n"
"\n"
"rename_termlist([],[],_,_,_).\n"
"\n"
"rename_term(C,A,Q,V,Mapping) :-\n"
"	var(C),\n"
"	!,\n"
"	map_varsrq(C,A,Q,V,Mapping).\n"
"\n"
"rename_term(C,C,Q,V,Mapping) :-\n"
"	\\+ compound(C), !.\n"
"\n"
"rename_term([],[],Q,V,Mapping) :-\n"
"	!.\n"
"\n"
"rename_term(C,A,Q,V,Mapping) :-\n"
"	C =.. [FC|Args],\n"
"	map_varsrq(FC,FA,Q,V,Mapping),\n"
"	rename_termlist(Args,RenArgs,Q,V,Mapping),\n"
"	A =.. [FA|RenArgs].\n"
"\n"
"map_varsrq(C,C,_,_,_) :-\n"
"	\\+ var(C).\n"
"\n"
"map_varsrq(C,A,Q,V,[(A,Var)|_]) :-\n"
"	var(C),\n"
"	my_nth(N,V,C),\n"
"	my_nth(N,Q,C2),\n"
"	var_is_same(C2,Var),\n"
"	!.\n"
"\n"
"map_varsrq(C,A,Q,V,[_|Mapping]) :-\n"
"	var(C),\n"
"	map_varsrq(C,A,Q,V,Mapping).\n"
"\n"
"map_varsrq(C,C,_,_,[]).\n"
"\n"
"\n"
"prepare_ifx_mapping(Mapping,Vars,\n"
"		   [form_result(VarsV,Names,ResMapping)],\n"
"		   [\n"
"		    ( form_result([],[],[]) ),\n"
"		    ( form_result([V|VarsTail],[Name|NTail],[(Name,V)|MTail]) :- form_result(VarsTail,NTail,MTail) )\n"
"		   ],\n"
"		   ResMapping\n"
"		   ) :-\n"
"	get_vars_objvar(VarsV),\n"
"	form_indexed_mapping(Mapping,Vars,IndexedMapping),\n"
"	keysort(IndexedMapping,SortedMappingByVars),\n"
"	extract_names(SortedMappingByVars,Names).\n"
"\n"
"form_indexed_mapping([],_,[]).\n"
"%\n"
"form_indexed_mapping([(ASPName,Var)|Mapping],Vars,[Index-ASPName|IndexedMapping]) :-\n"
"	get_index(Var,Vars,Index),\n"
"	form_indexed_mapping(Mapping,Vars,IndexedMapping).\n"
"\n"
"extract_names([],[]).\n"
"%\n"
"extract_names([_-ASPName|Mapping],[ASPName|Names]) :-\n"
"	extract_names(Mapping,Names).\n"
"\n"
"\n"
"\n"
"portray_clauses([]).\n"
"%\n"
"portray_clauses([(:- Body)|Tail]) :-\n"
"	!,	% special pretty-printing for directives, which don't work well with portray_clause\n"
"	write(':- '), portray_clause(Body), nl,\n"
"	portray_clauses(Tail).\n"
"%	\n"
"portray_clauses([C|Tail]) :-\n"
"	portray_clause(C), nl,\n"
"	portray_clauses(Tail).\n"
"\n"
"\n"
"\n"
"\n"
"turn_into_commas([],true).\n"
"%\n"
"turn_into_commas([T],T).\n"
"%\n"
"turn_into_commas([T|Tail],(T,Rest)) :-\n"
"	turn_into_commas(Tail,Rest).\n"
"\n"
"\n"
"map_local_constraint(fd,ezcsp__lt,#<).\n"
"map_local_constraint(fd,ezcsp__gt,#>).\n"
"map_local_constraint(fd,ezcsp__leq,#=<).\n"
"map_local_constraint(fd,ezcsp__geq,#>=).\n"
"map_local_constraint(fd,ezcsp__eq,#=).\n"
"map_local_constraint(fd,ezcsp__neq,#\\=).\n"
"map_local_constraint(fd,ezcsp__impl_r,#=>).\n"
"map_local_constraint(fd,ezcsp__impl_l,#<=).\n"
"map_local_constraint(fd,ezcsp__or,#\\/).\n"
"map_local_constraint(fd,ezcsp__and,#/\\).\n"
"map_local_constraint(fd,ezcsp__xor,#\\).\n"
"map_local_constraint(fd,ezcsp__diff,#<=>).\n"
"map_local_constraint(fd,ezcsp__not,#\\).\n"
"%\n"
"map_local_constraint(r,ezcsp__lt,<).\n"
"map_local_constraint(r,ezcsp__gt,>).\n"
"map_local_constraint(r,ezcsp__leq,=<).\n"
"map_local_constraint(r,ezcsp__geq,>=).\n"
"map_local_constraint(r,ezcsp__eq,=).\n"
"map_local_constraint(r,ezcsp__neq,\\=).\n"
"map_local_constraint(r,ezcsp__impl_r,=>).\n"
"map_local_constraint(r,ezcsp__impl_l,<=).\n"
"map_local_constraint(r,ezcsp__or,\\/).\n"
"map_local_constraint(r,ezcsp__and,/\\).\n"
"map_local_constraint(r,ezcsp__xor,\\).\n"
"map_local_constraint(r,ezcsp__diff,<=>).\n"
"map_local_constraint(r,ezcsp__not,\\).\n"
"%\n"
"map_local_constraint(q,E,C) :-\n"
"	map_local_constraint(r,E,C).\n"
"\n"
"\n"
"\n"
"map_csp_function(ezcsp__pl,+).\n"
"map_csp_function(ezcsp__mn,-).\n"
"map_csp_function(ezcsp__tm,*).\n"
"map_csp_function(ezcsp__dv,/).\n"
"map_csp_function(ezcsp__mod,mod).\n"
"map_csp_function(ezcsp__max,max).\n"
"map_csp_function(ezcsp__min,min).\n"
"map_csp_function(ezcsp__abs,abs).\n"
"map_csp_function(ezcsp__pow,pow).	% NEW FROM HERE\n"
"map_csp_function(ezcsp__exp,exp).\n"
"map_csp_function(ezcsp__sin,sin).\n"
"map_csp_function(ezcsp__cos,cos).\n"
"map_csp_function(ezcsp__tan,tan).\n"
"\n"
"\n"
"\n"
"\n"
"is_local_constraint(ezcsp__lt).\n"
"is_local_constraint(ezcsp__gt).\n"
"is_local_constraint(ezcsp__leq).\n"
"is_local_constraint(ezcsp__geq).\n"
"is_local_constraint(ezcsp__eq).\n"
"is_local_constraint(ezcsp__neq).\n"
"is_local_constraint(ezcsp__impl_r).\n"
"is_local_constraint(ezcsp__impl_l).\n"
"is_local_constraint(ezcsp__or).\n"
"is_local_constraint(ezcsp__and).\n"
"is_local_constraint(ezcsp__xor).\n"
"is_local_constraint(ezcsp__diff).\n"
"is_local_constraint(ezcsp__not).\n"
"\n"
"\n"
"is_list_var_rel(REL,ARGS) :-\n"
"	length(ARGS,Arity),\n"
"	list_CSP_rel(REL,Arity,_).\n"
"\n"
"\n"
"map_global_constraint(REL,ARGS,PLREL) :-\n"
"	length(ARGS,Nargs),\n"
"	map_global_constraint_nargs(REL,Nargs,PLREL),\n"
"	!.\n"
"\n"
"map_global_constraint(REL,_,REL).\n"
"\n"
"\n"
"% name mapping for certain global constraints\n"
"map_global_constraint_nargs(ezcsp__sum,3,sum).\n"
"map_global_constraint_nargs(cumulative,4,abstr_cumulative) :- sicstus4.\n"
"\n"
"\n"
"%\n"
"% Allowed argument types:\n"
"%\n"
"%    csp: name of CSP function -- will be turned into a list.\n"
"%    asp: name of ASP (functional) relation -- will be turned into a list)\n"
"%    expr: expression, possibly containing CSP functions (CSP functions will be replaced by corresp. variables)\n"
"%    rel(MatchingRelation): CSP relation (e.g. ezcsp__gt) -- relation MatchingRelation will be used to map it to the appropriate CSP relation, e.g. rel(match_CSP_relation) may cause the use of match_CSP_relation(ezcsp__gt,#>).\n"
"%\n"
"global_constraint_spec(ezcsp__sum,3,[csp,rel(match_CSP_relation),expr]).\n"
"global_constraint_spec(minimum,2,[expr,csp]).\n"
"global_constraint_spec(maximum,2,[expr,csp]).\n"
"global_constraint_spec(scalar_product,4,[asp,csp,rel(match_CSP_relation),expr]).\n"
"global_constraint_spec(serialized,2,[csp,asp]).\n"
"global_constraint_spec(cumulative,4,[csp,asp,asp,expr]).\n"
"global_constraint_spec(disjoint2,4,[csp,asp,csp,asp]).\n"
"global_constraint_spec(all_different,1,[csp]).\n"
"global_constraint_spec(all_distinct,1,[csp]).\n"
"global_constraint_spec(count,4,[expr,csp,rel(match_CSP_relation),expr]).\n"
"global_constraint_spec(element,3,[expr,csp,expr]).\n"
"global_constraint_spec(assignment,2,[csp,csp]).\n"
"global_constraint_spec(circuit,1,[csp]).\n"
"global_constraint_spec(circuit,2,[csp,csp]).\n"
"\n"
"%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\n"
"/*\n"
"% put cspdomain(fd) at the top of this file.\n"
"cspvar(st(0,c),0,200).\n"
"cspvar(st(1,c),0,200).\n"
"cspvar(st(2,c),0,200).\n"
"cspvar(st(0,b),0,200).\n"
"cspvar(st(1,b),0,200).\n"
"cspvar(st(2,b),0,200).\n"
"cspvar(st(0,a),0,200).\n"
"cspvar(st(1,a),0,200).\n"
"cspvar(st(2,a),0,200).\n"
"part_len(2,c,9).\n"
"part_len(2,b,8).\n"
"part_len(2,a,7).\n"
"part_len(1,c,6).\n"
"part_len(1,b,5).\n"
"part_len(1,a,4).\n"
"part_len(0,c,3).\n"
"part_len(0,b,2).\n"
"part_len(0,a,1).\n"
"r(2,c,1).\n"
"r(2,b,1).\n"
"r(2,a,1).\n"
"r(1,c,1).\n"
"r(1,b,1).\n"
"r(1,a,1).\n"
"r(0,c,1).\n"
"r(0,b,1).\n"
"r(0,a,1).\n"
"required(cumulative(st,f(part_len,3),r,1)).\n"
"*/\n"
"/*\n"
"% put cspdomain(fd) at the top of this file.\n"
"required(ezcsp__geq(st(0,c),ezcsp__pl(st(0,b),2))).\n"
"required(ezcsp__geq(st(1,c),ezcsp__pl(st(1,b),5))).\n"
"required(ezcsp__geq(st(2,c),ezcsp__pl(st(2,b),8))).\n"
"required(ezcsp__geq(st(0,b),ezcsp__pl(st(0,a),1))).\n"
"required(ezcsp__geq(st(1,b),ezcsp__pl(st(1,a),4))).\n"
"required(ezcsp__geq(st(2,b),ezcsp__pl(st(2,a),7))).\n"
"required(sum(st,ezcsp__lt,100)).\n"
"maezcsp__sum(8).\n"
"part_len(2,c,9).\n"
"part_len(2,b,8).\n"
"part_len(2,a,7).\n"
"part_len(1,c,6).\n"
"part_len(1,b,5).\n"
"part_len(1,a,4).\n"
"part_len(0,c,3).\n"
"part_len(0,b,2).\n"
"part_len(0,a,1).\n"
"precedes(b,c).\n"
"precedes(a,b).\n"
"part(c).\n"
"part(b).\n"
"part(a).\n"
"job(0).\n"
"job(1).\n"
"job(2).\n"
"cspvar(st(0,c),0,20).\n"
"cspvar(st(1,c),0,20).\n"
"cspvar(st(2,c),0,20).\n"
"cspvar(st(0,b),0,20).\n"
"cspvar(st(1,b),0,20).\n"
"cspvar(st(2,b),0,20).\n"
"cspvar(st(0,a),0,20).\n"
"cspvar(st(1,a),0,20).\n"
"cspvar(st(2,a),0,20).\n"
"%%endmodel\n"
"*/\n"
"\n"
;
