// Copyright (c) 2008, Roland Kaminski
//
// This file is part of GrinGo.
//
// GrinGo is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// GrinGo is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with GrinGo.  If not, see <http://www.gnu.org/licenses/>.

#include "cterm.h"
#include "grounder.h"
#include <sstream>

using namespace NS_GRINGO;


CTerm::CTerm(Grounder* g, Value v) : g_(g), v_(v)//, ops_[0](NULL), ops_[1](NULL)
{
	ops_[0] = NULL;
	ops_[1] = NULL;
}

CTerm::CTerm(Grounder* g, Operator op, CTerm a) : g_(g), id_(op)//, ops_[0](new CTerm(a)), ops_[1](NULL)
{
	ops_[0] = new CTerm(a);
	ops_[1] = NULL;
}

CTerm::CTerm(Grounder* g, Operator op, CTerm a, CTerm b) : g_(g), id_(op)//, ops_[0](new CTerm(a)), ops_[1](new CTerm(b))
{
	ops_[0] = new CTerm(a);
	ops_[1] = new CTerm(b);
}

CTerm::CTerm(const CTerm &f) : g_(f.g_), id_(f.id_), v_(f.v_)//, (f.ops_[0] != NULL ? ops_[0](new CTerm(f.ops_[0])) : ops_[0](NULL)),
                                                                   //  (f.ops_[1] != NULL ? ops_[1](new CTerm(f.ops_[1])) : ops_[1](NULL))
{
	ops_[0] = (f.ops_[0] != NULL ? new CTerm(*f.ops_[0]) : NULL);
	ops_[1] = (f.ops_[1] != NULL ? new CTerm(*f.ops_[1]) : NULL);
}

std::string CTerm::getString() const
{
	if (ops_[0] == NULL)
	{
		std::string ret;
		addValueToString(v_, ret);
		return ret;
	}
	else
	{
		switch(id_)
		{
			case PLUS:
				return ops_[0]->getString() + "+" + ops_[1]->getString(); 
			case MINUS:
				return ops_[0]->getString() + "-" + ops_[1]->getString(); 
			case TIMES:
				return ops_[0]->getString() + "*" + ops_[1]->getString(); 
			case DIVIDE:
				return ops_[0]->getString() + "/" + ops_[1]->getString(); 
			case ABS:
				return "abs(" + ops_[0]->getString() + ")"; 

		}
	}
	assert(false);
	return "";

}


void CTerm::addValueToString(const Value v, std::string& add) const
{

	if (v.type_ == Value::FUNCSYMBOL)
	{
		add += *(g_->getString(g_->getFuncSymbol(v.uid_)->getName()));
		ValueVector vv = g_->getFuncSymbol(v.uid_)->getValues();
		
		if (vv.size() > 0)
			add += "(";
		for (ValueVector::const_iterator i =  vv.begin();
                                       i != vv.end(); )
		{
			addValueToString(*i, add);
			if (++i != vv.end())
				add += ",";
		}
		if (vv.size() > 0)
			add += ")";
		return;
	}
	else
	if (v.type_ == Value::INT)
	{
		//damn shit, this sucks
		std::stringstream ss;
		ss << v.uid_;

		add += ss.str().c_str();
	}
	else
	if (v.type_ == Value::STRING)
	{
		add += *g_->getString(v.uid_);
	}
	else
	{
		assert(false);
		return;
	}
}

CTerm::~CTerm()
{
	if (ops_[0] != NULL)
		delete ops_[0];
	if (ops_[1] != NULL)
		delete ops_[1];
}
