// Copyright (c) 2008, Roland Kaminski
//
// This file is part of GrinGo.
//
// GrinGo is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// GrinGo is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with GrinGo.  If not, see <http://www.gnu.org/licenses/>.

#include "cspliteral.h"
#include "statementdependencygraph.h"
#include "term.h"
#include "value.h"
#include "indexeddomain.h"
#include "literaldependencygraph.h"
#include "statementchecker.h"
#include "grounder.h"

using namespace NS_GRINGO;

TermVector *CSPLiteral::createTermVector(Term *a,Term *b)
{	TermVector *tv=new TermVector();
	tv->push_back(a);
	tv->push_back(b);

std::cerr << "in createTermVector" << std::endl;

	return(tv);
}

//CSPLiteral::CSPLiteral(Grounder *g, RelationType type, Term *a, Term *b) : PredicateLiteral(g,type,createTermVector(a,b)), type_(type), a_(a), b_(b), predUid_(g->createPred(g->createString(""), 1)), predNode_(g->getDomain(predUid_))
//CSPLiteral::CSPLiteral(Grounder *g, int type, Term *a, Term *b) : PredicateLiteral(g,type,createTermVector(a,b)), type_(EQ), a_(a), b_(b), predUid_(g->createPred(g->createString(""), 1)), predNode_(g->getDomain(predUid_))
CSPLiteral::CSPLiteral(Grounder *g, int type, Term *a, Term *b) : PredicateLiteral(g,type,new TermVector()), type_(EQ), a_(a), b_(b), predUid_(g->createPred(g->createString(""), 1)), predNode_(g->getDomain(predUid_))
{
}

SDGNode *CSPLiteral::createNode(SDG *dg, SDGNode *prev, DependencyAdd todo)
{
std::cerr << "csplit's createNode0" << std::endl;
	prev->addDependency(prev, true);
std::cerr << "csplit's createNode0a" << std::endl;
	//return dg->createPredicateNode(predNode_, predUid_);
	SDGNode *rrr=dg->createPredicateNode(predNode_, predUid_);
	return(rrr);
}

void CSPLiteral::createNode(LDGBuilder *dg, bool head)
{
std::cerr << "csplit's createNode1" << std::endl;
	assert(!head);
	VarSet needed, provided;
	a_->getVars(needed);
	if(b_)
		b_->getVars(needed);
	dg->createNode(this, head, needed, provided);
}

void CSPLiteral::createNode(StatementChecker *dg, bool head, bool delayed)
{
std::cerr << "csplit's createNode2" << std::endl;
	assert(!head && !delayed);
	VarSet needed, provided;
	a_->getVars(needed);
	b_->getVars(needed);
	dg->createNode(needed, provided);
}

void CSPLiteral::print(const GlobalStorage *g, std::ostream &out) const
{
std::cerr << "csplit's print" << std::endl;
	out << pp(g, a_);
	switch(type_)
	{ 
		case EQ:
			out << " == ";
			break;
		case NE:
			out << " != ";
			break;
		case GT:
			out << " > ";
			break;
		case GE:
			out << " >= ";
			break;
		case LE:
			out << " <= ";
			break;
		case LT:
			out << " < ";
			break;
	}
	out << pp(g, b_);
}

bool CSPLiteral::isFact(Grounder *g)
{
	//return true;
	return false;
}

bool CSPLiteral::solved()
{
//	return true;
	return false;
}

void CSPLiteral::getVars(VarSet &vars) const
{
	a_->getVars(vars);
	b_->getVars(vars);
}

bool CSPLiteral::checkO(LiteralVector &unsolved)
{
	return true;
}

void CSPLiteral::reset()
{
	assert(false);
}

void CSPLiteral::finish()
{
	assert(false);
}

bool CSPLiteral::match(Grounder *g)
{
	// create unique string and cspconstraint
	//constraint_.clear();
	constraint_ = Clasp::CSPConstraint();
	Clasp::CSPConstraint* a = a_->getCSPConstraint(g);
	Clasp::CSPConstraint* b = b_->getCSPConstraint(g);
	std::string s(a_->getCTerm(g).getString());
	switch(type_)
	{
		case EQ:
			s += "$==";
			constraint_.setRelation(Clasp::CSPConstraint::EQ, a, b);
			break;
		case NE:
			s += "$!=";
			constraint_.setRelation(Clasp::CSPConstraint::NE, a, b);
			break;
		case GT:
			s += "$>";
			constraint_.setRelation(Clasp::CSPConstraint::GT, a, b);
			break;
		case GE:
			s += "$>=";
			constraint_.setRelation(Clasp::CSPConstraint::GE, a, b);
			break;
		case LE:
			s += "$=<";
			constraint_.setRelation(Clasp::CSPConstraint::LE, a, b);
			break;
		case LT:
			s += "$<";
			constraint_.setRelation(Clasp::CSPConstraint::LT, a, b);
			break;
		default:
			assert(false);
	}
	
	s += b_->getCTerm(g).getString();
	value_ = g->createString(s);

	return true;
}

void CSPLiteral::preprocess(Grounder *g, Expandable *e)
{
	a_->preprocess(this, a_, g, e);
	b_->preprocess(this, b_, g, e);
}

void CSPLiteral::addIncParam(Grounder *g, const Value &v)
{
	a_->addIncParam(g, a_, v);
	b_->addIncParam(g, b_, v);
}

double CSPLiteral::heuristicValue()
{
	// match it as soon as possible
	return 0;
}

IndexedDomain *CSPLiteral::createIndexedDomain(Grounder *g, VarSet &index)
{
	return new IndexedDomainMatchOnly(this);
}

CSPLiteral::CSPLiteral(const CSPLiteral &r) : PredicateLiteral(r), type_(r.type_), a_(r.a_->clone()), b_(r.b_->clone()), predUid_(r.predUid_), predNode_(r.predNode_)
{
}

Literal* CSPLiteral::clone() const
{
	return new CSPLiteral(*this);
}

NS_OUTPUT::Object *CSPLiteral::convert()
{
	ValueVector values;
	values.push_back(Value(Value::STRING, value_));
	return new NS_OUTPUT::CSPAtom(getNeg(), predNode_, predUid_, values, constraint_);
}

CSPLiteral::~CSPLiteral()
{
	if(a_)
		delete a_;
	if(b_)
		delete b_;
}

