// Copyright (c) 2008, Roland Kaminski
//
// This file is part of GrinGo.
//
// GrinGo is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// GrinGo is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with GrinGo.  If not, see <http://www.gnu.org/licenses/>.

#ifndef TATOM_PREDICATELITERAL_H
#define TATOM_PREDICATELITERAL_H

#include <gringo.h>
#include <literal.h>
#include <predicateliteral.h>
#include <groundable.h>
#include <expandable.h>
#include <value.h>
#include <clasp/include/cspconstraint.h>

namespace NS_GRINGO
{
	class TAtomPredicateLiteral : public PredicateLiteral
	{
	public:
		enum RelationType { EQ, NE, GT, GE, LE, LT };
	public:
		TAtomPredicateLiteral(Grounder *g, RelationType type, Term *a, Term *b); //, TermVector *variables);
		TAtomPredicateLiteral(const TAtomPredicateLiteral &p);
		virtual Literal* clone() const;
		void setWeight(Term *w);
		virtual void createNode(StatementChecker *dg, bool head, bool delayed);
		virtual void print(const GlobalStorage *g, std::ostream &out) const;
		virtual bool isFact(Grounder *g);
		virtual bool isFact(const ValueVector &values);
		virtual IndexedDomain *createIndexedDomain(Grounder *g, VarSet &index);
		virtual bool match(Grounder *g);
		virtual bool match(const ValueVector &values);
		virtual NS_OUTPUT::Object *convert();
		virtual NS_OUTPUT::Object *convert(const ValueVector &values);
		virtual double heuristicValue();
		//int getId();
		//TermVector *getArgs();
		//int getUid();
		//int getArity() const;
		//void addDomain(ValueVector &values);
		//Domain *getDomain() const;
		//const ValueVector &getValues();
		virtual ~TAtomPredicateLiteral();

		//virtual bool solved();
	protected:
		static TermVector *createTermVector(Term *a,Term *b);
		static std::string connectorString(RelationType type);
		Clasp::CSPConstraint* getCSPConstraintOfValue(Grounder *g,const Value& v);

		/* returns the number of terms (as opposed to domain values) in the t-atom */
		int nTerms(const ValueVector &values);
		bool isFTerm(Term *a,int idx,const ValueVector &values);
		bool isShown(Term *a,int idx,const ValueVector &values);
		bool isHidden(Term *a,int idx,const ValueVector &values);
		bool isUndefined(Term *a);

		RelationType type_;

		bool headTAtom_;

		Grounder *g_;
	};

	class HeadTAtomPredicateLiteral : public TAtomPredicateLiteral
	{
	public:
		HeadTAtomPredicateLiteral(Grounder *g, RelationType type, Term *a, Term *b) : TAtomPredicateLiteral(g,type,a,b)
		{ headTAtom_=true; }
		HeadTAtomPredicateLiteral(const HeadTAtomPredicateLiteral &p) : TAtomPredicateLiteral(p)
		{}
	};
}

#endif

