// Copyright (c) 2008, Roland Kaminski
//
// This file is part of GrinGo.
//
// GrinGo is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// GrinGo is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with GrinGo.  If not, see <http://www.gnu.org/licenses/>.

#ifndef CTERM_H
#define CTERM_H

#include <gringo.h>
#include <funcsymbol.h>
#include "value.h"

namespace NS_GRINGO
{
	class CTerm
	{
	public:
		enum Operator
		{
			PLUS,
			MINUS,
			TIMES,
			DIVIDE,
			ABS
		};

		CTerm(Grounder* g, Value v);
		CTerm(Grounder* g, Operator op, CTerm a);
		CTerm(Grounder* g, Operator op, CTerm a, CTerm b);
		CTerm(const CTerm &f);
		std::string getString() const;
		virtual ~CTerm();
	protected:
		Grounder* g_;

		/**
		 *
		 * type_ == CONSTANT, id_ is value of the constant
		 * type_ == VARIABLE, id_ is uid if the variable
		 * type_ == OPERATOR, id_ is of type Operator
		 *
		 */
		int id_;
		Value v_;

		CTerm* ops_[2];
	private:
		void addValueToString(const Value v, std::string& add) const;
	};
}

#endif

