// 
// Copyright (c) 2006-2007, Benjamin Kaufmann
// 
// This file is part of Clasp. See http://www.cs.uni-potsdam.de/clasp/ 
// 
// Clasp is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// Clasp is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with Clasp; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
//
#ifndef CLASP_CSPSOLVER_H_INCLUDED
#define CLASP_CSPSOLVER_H_INCLUDED

#include <clasp/include/cspconstraint.h>
#include <clasp/include/util/misc_types.h>
#include <clasp/include/solver.h>
#include <vector>

namespace Clasp { 

	class ProgramBuilder;

	class CSPSolver
	{
		public:
			virtual ~CSPSolver(){};
			/*
			 * adds a constraint with the uid of the atom representing the constraint
			 *
			 **/
			virtual void setDomain(int lower, int upper) = 0;
			virtual void addConstraint(CSPConstraint c, int uid) = 0;
			virtual unsigned int getVariable(const std::string& s);
			virtual void setSolver(Solver* s) = 0;
			virtual bool initialize(ProgramBuilder* b) = 0;
			virtual bool isConstraintLiteral(Literal l) = 0;
			virtual bool propagate(const LitVec& lv, bool& foundNewLits) = 0;
			virtual void undoUntil(unsigned int level) = 0;
			/*
			 * pre: complete assignment
			 * return true if a valid solution for the asp vars exists
			 * return false elsewise, generates a conflict
			 * post: the next answer can be called
			 *
			 * Only use this for the first answer
			 */
			virtual bool hasAnswer() = 0;
			virtual bool nextAnswer() = 0;
			/*
			 *pre: hasAnswer has been called and returned true
			 * prints the answer set
			 */
			virtual void printAnswer() = 0;

			virtual void allFTerm() = 0;
			virtual void setFTerm(int id, int arity) = 0;
			virtual bool isFTerm(int id, int arity) = 0;
			virtual void hideAll() = 0;
			virtual void setVisible(int id, int arity, bool visible) = 0;
			virtual bool isShown(int id, int arity)= 0;
			virtual bool isHidden(int id, int arity) = 0;

		protected:
			std::vector<std::string> variables_;
	};
}
#endif
