// 
// Copyright (c) 2006-2007, Benjamin Kaufmann
// 
// This file is part of Clasp. See http://www.cs.uni-potsdam.de/clasp/ 
// 
// Clasp is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// Clasp is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with Clasp; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
//
#ifndef CLASP_CSPCONSTRAINT_H_INCLUDED
#define CLASP_CSPCONSTRAINT_H_INCLUDED

//#include <clasp/include/util/misc_types.h>
#include <vector>
#include <set>

namespace Clasp { 

	class CSPConstraint
	{
		public:
			enum Type
			{
				VARIABLE,
				INTEGER,
				OPERATOR,
				RELATION,
				UNDEF

			};

			enum Relation
			{
				EQ,
				NE,
				LE,
				LT,
				GE,
				GT
			};
			enum Operator
			{
				ABS,
				PLUS,
				MINUS,
				TIMES,
				DIVIDE
			};

			CSPConstraint();
			CSPConstraint(const CSPConstraint& cc);
			const CSPConstraint operator=(const CSPConstraint& cc);
			~CSPConstraint();
			void setVariable(unsigned int var);
			void setInteger(int i);
			//void setReal(float f);
			/*
			 * takes ownership of the CSPConstraints
			 *
			 **/
			void setOperator(Operator op, CSPConstraint* a, CSPConstraint* b);
			void setRelation(Relation op, CSPConstraint* a, CSPConstraint* b);

			unsigned int getLinearSize() const;


			Type getType() const;
			unsigned int getVar() const;
			int getInteger() const;
			Operator getOperator(CSPConstraint*& a, CSPConstraint*& b) const;
			Relation getRelation(CSPConstraint*& a, CSPConstraint*& b) const;

			std::vector<unsigned int> getAllVariables();

			/* [marcy 041212] */
			void setFTerm(bool isFTerm) { isFTerm_=isFTerm; }
			bool isFTerm() { return(isFTerm_); }
			void setVisible(bool isVisible) { if (isVisible) isShown_=true; else isHidden_=true; }
			bool isShown() { return(isShown_); }
			bool isHidden() { return(isHidden_); }
			/* */
		
		private:
			void clear();
			Type type_;
			union
			{
				unsigned int var_;
				int integer_;
				Operator op_;
				Relation rel_;
			};
			bool isFTerm_;	/* [marcy 041212] */
			bool isShown_;	/* [marcy 041212] */
			bool isHidden_;	/* [marcy 041212] */
			CSPConstraint* a_;
			CSPConstraint* b_;
			unsigned int lin_; // lenght of the linear component, 1 if not linear (constant, variable, mult)

	};
}
#endif
