// 
// Copyright (c) 2006-2007, Benjamin Kaufmann
// 
// This file is part of Clasp. See http://www.cs.uni-potsdam.de/clasp/ 
// 
// Clasp is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// Clasp is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with Clasp; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
//
#ifndef CLASP_ASPF_H_INCLUDED
#define CLASP_ASPF_H_INCLUDED

#include <clasp/include/cspconstraint.h>
#include <clasp/include/cspsolver.h>
#include <clasp/include/util/misc_types.h>
#include <vector>
#include <map>
#include <set>
#include <sstream>

namespace Clasp { 


	class ASPfSolver : public CSPSolver
	{
//		private:
//			class SearchSpace;
		public:

			ASPfSolver(bool lazyLearn, bool useCDG, bool weakAS, int numAS, bool debug);
			virtual ~ASPfSolver();
			/*
			 * adds a constraint with the uid of the atom representing the constraint
			 *
			 **/
			virtual void setDomain(int lower, int upper) {};
			virtual void addConstraint(CSPConstraint c, int uid);
			virtual void setSolver(Solver* s);
			virtual bool initialize(ProgramBuilder* s);
			virtual bool isConstraintLiteral(Literal l);
			virtual bool propagate(const LitVec& lv, bool& foundNewLits);
			virtual void undoUntil(unsigned int level);
			/*
			 * pre: complete assignment
			 * return true if a valid solution for the asp vars exists
			 * return false elsewise, generates a conflict
			 * post: the next answer can be printed
			 */
			virtual bool hasAnswer();
			virtual bool nextAnswer();
			/*
			 *pre: hasAnswer has been called and returned true
			 * prints the answer set
			 */
			virtual void printAnswer();

			virtual void allFTerm() { ftermAll_=true; }
			virtual void setFTerm(int id, int arity);
			virtual bool isFTerm(int id, int arity);
			virtual void hideAll() { hideAll_=true; }
			virtual void setVisible(int id, int arity, bool visible);
			virtual bool isShown(int id, int arity);
			virtual bool isHidden(int id, int arity);


			//end public
			const LitVec& getAssignment() const;

		protected:

/* ASPfSolver stuff */
typedef CSPConstraint TermExpression;	/* Gecode's CSPConstraints are t-atoms and term expressions in the ASP{f} terminology */
//typedef CSPConstraint TAtom;		/* Gecode's CSPConstraints are t-atoms and term expressions in the ASP{f} terminology */
/* [marcy 041112] */
typedef std::pair<bool,int> TAtomValue;
/* */
			static bool isSatisfied(TAtomValue v1,int rel,TAtomValue v2);
			static std::string toString(TAtomValue v);
class TAtom
{
private:
	CSPConstraint cspconstraint_;
	bool isSeedTAtom_;
/* [marcy 041112] */
//	unsigned int seedTAtomValue_;
	TAtomValue seedTAtomValue_;
/* */
	unsigned int seedTAtomTermIndex_;
	Literal lit_;
	unsigned int claspVar_;
	ValueRep trueValue_;
	std::string name_;

	bool is_constant_[2];

	void detectSeedTAtom();
	bool shown_,hidden_;

public:
	TAtom();
	TAtom(CSPConstraint c);

	CSPConstraint cspconstraint() { return(cspconstraint_); }
	CSPConstraint *cspconstraintPtr() { return(&cspconstraint_); }

	bool isSeedTAtom() { return(isSeedTAtom_); }

	unsigned int seedTAtomTermIndex() { return(seedTAtomTermIndex_); }
/* [marcy 041112] */
//	unsigned int seedTAtomValue() { return(seedTAtomValue_); }
	TAtomValue seedTAtomValue() { return(seedTAtomValue_); }
/* */
/* [marcy 041112] */
	std::vector<unsigned int> getAllTerms(TermExpression *c);
//	std::vector<unsigned int> getAllTerms() { return(cspconstraintPtr()->getAllVariables()); }
	std::vector<unsigned int> getAllTerms() { return(getAllTerms(cspconstraintPtr())); }
/* */
	CSPConstraint::Type getType() { return(cspconstraintPtr()->getType()); }
	CSPConstraint::Relation getRelation(CSPConstraint*& a, CSPConstraint*& b) { return(cspconstraintPtr()->getRelation(a,b)); }

	void setLiteral(Literal lit) { lit_=lit; }
	void setClaspVar(unsigned int claspVar) { claspVar_=claspVar; }
	void setTrueValue(ValueRep trueValue) { trueValue_=trueValue; }
	void setName(std::string name) { name_=name; }

	Literal literal() { return(lit_); }
	unsigned int claspVar() { return(claspVar_); }
	ValueRep trueValue() { return(trueValue_); }
	std::string name() { return(name_); }
	bool isShown() { return(shown_); }
	bool isHidden() { return(hidden_); }

};

bool ftermAll_;
bool hideAll_;
std::vector<std::pair<int,int> > shown_,hidden_;
std::vector<std::pair<int,int> > fterms_;
/* [marcy 041112] */
//int *assignments;
TAtomValue *assignments;
/* */
bool *is_assigned;
int *assignment_level;
int n_terms;
std::map<int, std::vector<TAtom *> > seedTAtomsForTerm;
void displayTermExpression(TermExpression *c);
void growAssignments(TermExpression *c);
/* [marcy 041112] */
//bool getValueOfTermExpression(TermExpression *c,int &val);
bool getValueOfTermExpression(TermExpression *c,TAtomValue &val);
/* */
bool closureNogoodTriggered(TAtom *c);
bool recordTermAssignment(TAtom *c);
bool bruteForcePropagate(/*LitVec &lv*/bool &foundNewLits);

/*
 * \pre: all the terms of *c have been assigned a value
 *
 * Returns true if the t-atom is satisfied by the current
 * value assignment, and false otherwise.
 */
bool isTAtomSatisfied(TAtom *c);

void exploreRecursivelyClosure(TAtom *tatom,int term_idx,std::vector<unsigned int> &terms,TAtomValue *common_value,bool *in_common,int &n_in_common,bool *value_assigned);
bool closureNogoodLeftToRight(TAtom *c,bool &foundNewLits);
bool regularNogoodLeftToRight(TAtom *c,bool &foundNewLits);


class ASPfConstraint : public Clasp::Constraint
{
public:
	static ASPfConstraint *createStandard(ASPfSolver *aspf_,TAtom *tatom,bool useSelf,bool reasonTruthValue);

	ASPfConstraint(ASPfSolver *aspf,TAtom *tatom,LitVec& reason);

	void reason(const Literal& l, LitVec& reason);

	Constraint::PropResult propagate(const Clasp::Literal&, uint32&, Clasp::Solver&)
	{
		return Constraint::PropResult(true, true);
	}
	ConstraintType type() const {return Constraint_t::native_constraint;}
private:
	ASPfSolver* aspf_;
	LitVec reason_;
	std::string tatomName_;
};

friend class ASPfConstraint;
public:
bool isSeedTAtom(CSPConstraint *c);
protected:
/* */

//			bool propagateNewLiteralsToClasp(const LitVec& newLits);
			/*
			 * sets a conflict if no answer was found with this assignment
			 * pre: no answer has to be found with this assignment
			 */
//			void finalConflict();
			/*
			 * pre: cdg has been build
			 * param in: variable to start with
			 * param out: all dependencies of in
			 * sideeffect: visitedConstraints_ polluted
			 */
//			void findAllDependencies(unsigned int l, std::vector<unsigned int>& result);

			std::map<Var, std::vector<TAtom *> > tatoms_;
			Solver* s_;
//			std::vector<SearchSpace*> spaces_; // spaces_[dl_[Y]] is the fully propagated space of decicion level dl[Y]
//			SearchSpace* currentSpace_; // the current space
//			std::vector<unsigned int> dl_; // dl_[Y] = X. spaces_[Y] has decision level X
//			std::vector<unsigned int> assLength_; // length of the assignment of space X

//			typedef std::map<Literal, unsigned int> LitToAssPosition;
//			typedef std::map<unsigned int, unsigned int> AssPosToSize;

//			LitToAssPosition litToAssPosition_;
//			AssPosToSize assPosToSize_;



			typedef std::map<unsigned int, std::set<unsigned int> > IntToSet;
//			LitVec assignment_; //current/old assignemnt
////			LitVec assBeforeProp_; // assignment of (currentDecisionLevel-1) + one currently propagated c-atom
//			unsigned int currentDL_;
//			SearchSpace* enumerator_; // the space for enumerating constraint answer sets

			//everything for enumerating answers
//			Search::Options searchOptions_;
//			DFS<ASPfSolver::SearchSpace>* searchEngine_; // depth first search

//			bool lazyLearn_; // true for lazy(dummy) learning
//			bool useCDG_;    // true when using CDG for reason minimisation
//			bool weakAS_;    // true if only weak Answer sets shall be calculated
//			int  numAS_;     // number of answer sets of weakAS_ is false
//			int  asCounter_; // current number of answer sets calculated of the same propositional answer set
//			std::pair<int,int> domain_; // the global domain of all variables(and all intermediate variables, this could be a problem)
//			bool addedDomain_; // true if domain was already added

/*
Removed [marcy 020312]
			class CSPDummy : public Clasp::Constraint
			{
				public:
				CSPDummy(ASPfSolver* gecode) : gecode_(gecode){}
				void reason(const Literal& l, LitVec& reason);

				Constraint::PropResult propagate(const Clasp::Literal&, uint32&, Clasp::Solver&)
				{
					return Constraint::PropResult(true, true);
				}
				ConstraintType type() const {return Constraint_t::native_constraint;}
				private:
				ASPfSolver* gecode_;
			};

			friend class CSPDummy;
			CSPDummy dummyReason_;
*/
/*
Removed [marcy 020912]
		private:
			typedef std::set<unsigned int> ConstraintSet ;
			struct Node
			{
				ConstraintSet node_;				
			};
			std::vector<bool> visitedConstraints_; // helper variable for CDG search

			std::map<unsigned int, Node> dependencyGraph_; // graph of constraint dependencies <constraint uid, deps>
			std::vector<bool> usedVars_;



			class SearchSpace : public Space
			{
				public:
					enum Value
					{
						BFREE,
						BTRUE,
						BFALSE
					};

					//TODo, find a better way for litToVar, static, or smart
					SearchSpace(unsigned int numVar, std::map<int, CSPConstraint>& constraints,
						std::map<unsigned int, unsigned int>* litToVar,
						const std::vector<bool>& usedVars, int domMin, int domMax);
					SearchSpace(bool share, SearchSpace& sp);
					virtual SearchSpace* copy(bool share);
					void propagate(const LitVec& lv, Solver* s);
				//	bool propagate(const Literal lv, Solver* s);
					void print(const std::vector<std::string>& variables, std::vector<bool>& usedVars) const;
					LitVec getAssignment(const LitVec& as);
					Value getValueOfConstraint(const Literal& i);

				// delete litToVar and all shared memory between the spaces
					void cleanAll(); 
				private:
					void generateConstraint(CSPConstraint c, unsigned int boolvar);
					void generateLinearConstraint(CSPConstraint* c, IntArgs& args, IntVarArgs& array, unsigned int num);
					IntVar generateVariable(CSPConstraint c);

				IntVarArray x_;
				BoolVarArray b_;
				std::map<unsigned int, unsigned int>* litToVar_; // translates from clasp literal to boolean csp variable for reified constraints
			};
*/
	};
}
#endif
